<?php
session_start();
require_once("../includes/conecta.php");

header('Content-Type: application/json');

// Verifica se a ação é 'subscribe' e o ID da vaga foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'subscribe') {
    // Verificar se o ID do candidato está na sessão
    if (!isset($_SESSION['id'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'ID do candidato não está definido na sessão'
        ]);
        exit;
    }

    // Verificar se o ID da vaga foi enviado
    if (!isset($_POST['jobId']) || empty($_POST['jobId'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'ID da vaga não foi enviado ou está vazio'
        ]);
        exit;
    }

    try {
        // Captura os dados recebidos via POST
        $vaga_id = $_POST['jobId'];
        $empresa_id = $_POST['empresa_id']; // Informações sobre a empresa podem ser ajustadas conforme necessário
        $candidato_id = $_SESSION['id']; // Pega o ID do candidato da sessão
        $status = 1; // Status fixo conforme solicitado

        // Verificar se o usuário já se inscreveu nesta vaga
        $sqlCheck = "SELECT COUNT(*) FROM candidaturas WHERE vaga = :vaga AND candidato = :candidato";
        $stmtCheck = $pdo->prepare($sqlCheck);
        $stmtCheck->bindParam(':vaga', $vaga_id, PDO::PARAM_INT);
        $stmtCheck->bindParam(':candidato', $candidato_id, PDO::PARAM_INT);
        $stmtCheck->execute();
        $alreadySubscribed = $stmtCheck->fetchColumn();

        if ($alreadySubscribed > 0) {
            // Se o candidato já estiver inscrito, enviar mensagem de erro
            echo json_encode([
                'status' => 'error',
                'message' => 'Você já está inscrito nesta vaga.'
            ]);
            exit;
        }

        // Caso não esteja inscrito, proceder com a inserção da inscrição
        $sql = "INSERT INTO candidaturas (vaga, empresa, candidato, status) VALUES (:vaga, :empresa, :candidato, :status)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':vaga', $vaga_id, PDO::PARAM_INT);
        $stmt->bindParam(':empresa', $empresa_id, PDO::PARAM_INT);
        $stmt->bindParam(':candidato', $candidato_id, PDO::PARAM_INT);
        $stmt->bindParam(':status', $status, PDO::PARAM_INT);

        // Executar a query
        if ($stmt->execute()) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Inscrição realizada com sucesso!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Erro ao realizar inscrição. Tente novamente.'
            ]);
        }
    } catch (PDOException $e) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Erro na conexão com o banco de dados: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Dados inválidos. Ação não permitida.'
    ]);
}
