<?php
require_once("../includes/conecta.php");

// Define o cabeçalho como JSON
header('Content-Type: application/json');

try {
    // Consulta todas as categorias de vagas
    $query = $pdo->query("SELECT * FROM categorias_vagas ORDER BY id DESC");
    $categorias_vagas = $query->fetchAll(PDO::FETCH_ASSOC);

    // Retorna os dados no formato JSON
    echo json_encode([
        'status' => 'success',
        'categorias' => $categorias_vagas
    ]);
} catch (Exception $e) {
    // Em caso de erro, retorna uma mensagem de erro
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
