<?php
session_start();
require_once("../includes/conecta.php");

header('Content-Type: application/json');

// Variáveis fornecidas
$idCandidato = $_GET['pessoa_id']; // Exemplo de ID do candidato
$questionarioId = "1"; // Exemplo de ID do questionário

try {
    // Verifica se os parâmetros necessários foram fornecidos (usando variáveis definidas)
    if (empty($questionarioId) || empty($idCandidato)) {
        throw new Exception('Parâmetros "questionarioId" e "idCandidato" são necessários.');
    }

    // Prepara a consulta SQL ajustada
    $query = "
    WITH answer_ranks AS (
        SELECT
            qr.prg_id,
            qr.rsp_id,
            ROW_NUMBER() OVER (PARTITION BY qr.prg_id ORDER BY qr.rsp_id) AS answer_order
        FROM qst_respostas qr
        JOIN qst_perguntas qp ON qr.prg_id = qp.prg_id
        WHERE qp.qst_id = :questionario_id
    ),
    user_answers AS (
        SELECT
            res.prg_id,
            res.rsp_id,
            ar.answer_order
        FROM qst_resultados res
        JOIN answer_ranks ar ON res.prg_id = ar.prg_id AND res.rsp_id = ar.rsp_id
        JOIN qst_perguntas qp ON res.prg_id = qp.prg_id
        JOIN candidatos c ON res.usr_id = c.id
        WHERE c.id = :pessoa_id
        AND qp.qst_id = :questionario_id
    )
    SELECT
        SUM(CASE WHEN answer_order = 1 THEN 1 ELSE 0 END) AS count_a,
        SUM(CASE WHEN answer_order = 2 THEN 1 ELSE 0 END) AS count_b,
        SUM(CASE WHEN answer_order = 3 THEN 1 ELSE 0 END) AS count_c,
        SUM(CASE WHEN answer_order = 4 THEN 1 ELSE 0 END) AS count_d,
        COUNT(*) AS total
    FROM user_answers;
    ";

    // Prepara a declaração
    $stmt = $pdo->prepare($query);

    // Vincula os parâmetros usando as variáveis definidas
    $stmt->bindParam(':questionario_id', $questionarioId, PDO::PARAM_INT);
    $stmt->bindParam(':pessoa_id', $idCandidato, PDO::PARAM_INT);

    // Executa a declaração
    $stmt->execute();

    // Obtém o resultado
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Retorna o resultado em formato JSON
    echo json_encode($result);
} catch (Exception $e) {
    // Retorna uma mensagem de erro em formato JSON
    echo json_encode(['error' => $e->getMessage()]);
}
