<?php
header("Content-Type: application/json; charset=UTF-8"); // Define o tipo de conteúdo da resposta como JSON
require_once("../includes/conecta.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../PHPMailer/src/Exception.php';
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';

// Inicializa as variáveis com valores vazios
$username = $nome = $password = $confirm_password = "";
$username_err = $nome_err = $password_err = $confirm_password_err = "";
$foto_avatar = "images/usuarios/pixel.png";

// Verifica se a requisição é para cadastrar um candidato
if (isset($_GET['candidato']) && $_GET['candidato'] == 1) {

    // Verificar se todos os campos necessários estão presentes
    if (empty($_POST['email']) || empty($_POST['password']) || empty($_POST['confirm_password']) || empty($_POST['nome'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Todos os campos são obrigatórios.'
        ]);
        exit;
    }

    // Validação de email
    if (empty(trim($_POST["email"]))) {
        $username_err = "Por favor, insira um e-mail.";
    } elseif (!filter_var(trim($_POST["email"]), FILTER_VALIDATE_EMAIL)) {
        $username_err = "O e-mail inserido não é válido.";
    } else {
        // Consulta para verificar se o e-mail já existe
        $sql = "SELECT id FROM candidatos WHERE email = :email";
        if ($stmt = $pdo->prepare($sql)) {
            $stmt->bindParam(":email", $param_username, PDO::PARAM_STR);
            $param_username = trim($_POST["email"]);

            if ($stmt->execute()) {
                if ($stmt->rowCount() == 1) {
                    $username_err = "Este e-mail já está em uso.";
                }
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Erro ao verificar e-mail.']);
                exit;
            }
            unset($stmt);
        }
    }

    // Validação de senha
    if (empty(trim($_POST["password"]))) {
        $password_err = "Por favor, insira uma senha.";
    } elseif (strlen(trim($_POST["password"])) < 6) {
        $password_err = "A senha deve ter pelo menos 6 caracteres.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Confirmar senha
    if (empty(trim($_POST["confirm_password"]))) {
        $confirm_password_err = "Por favor, confirme a senha.";
    } else {
        $confirm_password = trim($_POST["confirm_password"]);
        if ($password != $confirm_password) {
            $confirm_password_err = "As senhas não coincidem.";
        }
    }

    // Verifica se há erros antes de inserir no banco de dados
    if (empty($username_err) && empty($password_err) && empty($confirm_password_err)) {

        // Gerar um valor aleatório
        $randomValue = uniqid(mt_rand(), true);

        // Gerar o token MD5
        $token = md5($randomValue);
        $statusConta = "0";

        // Preparar a query de inserção
        $sql = "INSERT INTO candidatos (email, nome, foto, password, token, status_conta) VALUES (:email, :nome, :foto, :password, :token, :status_conta)";
        if ($stmt = $pdo->prepare($sql)) {
            // Vincular os parâmetros
            $stmt->bindParam(":email", $param_username, PDO::PARAM_STR);
            $stmt->bindParam(":nome", $param_nome, PDO::PARAM_STR);
            $stmt->bindParam(":foto", $param_foto, PDO::PARAM_STR);
            $stmt->bindParam(":password", $param_password, PDO::PARAM_STR);
            $stmt->bindParam(":token", $token, PDO::PARAM_STR);
            $stmt->bindParam(":status_conta", $statusConta, PDO::PARAM_STR);

            // Definir os valores
            $param_nome = trim($_POST["nome"]);
            $param_foto = $foto_avatar;
            $param_password = password_hash($password, PASSWORD_DEFAULT); // Criptografar a senha

            // Executa a inserção no banco de dados
            if ($stmt->execute()) {




                // DISPARA EMAIL

                // Instanciar PHPMailer
                $mail = new PHPMailer(true);

                try {
                    // Configurações do servidor SMTP
                    $mail->isSMTP();
                    $mail->Host = 'mail.pixeldev.com.br';
                    $mail->SMTPAuth = true;
                    $mail->Username = 'destaque@pixeldev.com.br';
                    $mail->Password = 'pixel1470@';
                    $mail->SMTPSecure = 'tls'; // Ou 'ssl', dependendo das configurações do seu servidor
                    $mail->Port = 587; // Ou a porta que seu servidor SMTP está utilizando

                    // Configurações do e-mail
                    $mail->setFrom('destaque@pixeldev.com.br', 'Destaque');
                    //$mail->addAddress('interwender@gmail.com', 'Septra');
                    $mail->addAddress($param_username, 'Destaque');
                    $mail->addBCC('interwender@gmail.com'); // Adiciona cópia oculta
                    $mail->Subject = "Seja bem vindo(a) ative sua conta!";
                    $mail->isHTML(true); // Define o corpo do e-mail como HTML
                    $mail->Body = '
                        <html>
                        <head>
                        <title>Seja bem vindo(a) a Destaque, ative sua conta!</title>
                        </head>
                        <body>
                        <p>Olá <b>' . $param_nome . '</b>! Segue abaixo link para ativação da sua conta!</p>
                        <p><b>E-mail:</b> ' . $param_username . '</p>
                        <p>
                            <a href="' . $urlgeral . 'painel/api/validar_candidato.php?token=' . $token . '" target="_blank" style="font-size:20px">
                                Ativar conta
                            </a>
                        </p>
                        <p><b>A equipe Destaque deseja todo sucesso!</b></p>
                        
                        </body>
                        </html>
                        ';
                    // Enviar e-mail
                    $mail->send();
                } catch (Exception $e) {
                    echo "Erro ao enviar e-mail: {$mail->ErrorInfo}";
                }






                echo json_encode(['status' => 'success', 'message' => 'Usuário cadastrado com sucesso.']);
                exit;
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Erro ao inserir no banco de dados.']);
                exit;
            }
            unset($stmt);
        }
    } else {
        // Retornar erros de validação
        echo json_encode([
            'status' => 'error',
            'username_err' => $username_err,
            'password_err' => $password_err,
            'confirm_password_err' => $confirm_password_err
        ]);
        exit;
    }

    unset($pdo);
} else {
    // Caso o parâmetro de candidato não seja válido
    echo json_encode(['status' => 'error', 'message' => 'Requisição inválida.']);
}
