<?php
session_start();
require_once("../includes/conecta.php");

header('Content-Type: application/json');

// Verifique se o método da solicitação é POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Recebe o corpo da solicitação
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['usuarioId']) && isset($data['questionarioId']) && isset($data['respostas'])) {
        $usuarioId = $data['usuarioId'];
        $questionarioId = $data['questionarioId'];
        $respostas = $data['respostas'];

        try {
            // Inicia a transação
            $pdo->beginTransaction();

            // Insere as respostas
            foreach ($respostas as $perguntaId => $respostaId) {
                $perguntaId = str_replace('pergunta_', '', $perguntaId);
                $query = "INSERT INTO qst_resultados (usr_id, prg_id, rsp_id) VALUES (:usr_id, :prg_id, :rsp_id)";
                $stmt = $pdo->prepare($query);
                $stmt->execute([
                    ':usr_id' => $usuarioId,
                    ':prg_id' => $perguntaId,
                    ':rsp_id' => $respostaId
                ]);
            }

            // Insere os resultados consolidados
            $query = "INSERT INTO qst_resultados_consolidados (usr_id, qst_id) VALUES (:usr_id, :qst_id)";
            $stmt = $pdo->prepare($query);
            $stmt->execute([
                ':usr_id' => $usuarioId,
                ':qst_id' => $questionarioId
            ]);

            // Comita a transação
            $pdo->commit();
            echo json_encode(['status' => 'success']);
        } catch (Exception $e) {
            // Reverte a transação em caso de erro
            $pdo->rollBack();
            echo json_encode(['status' => 'error', 'message' => 'Erro ao salvar respostas do questionário: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Dados inválidos']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Método não permitido']);
}
