<?php
session_start();
require_once("../includes/conecta.php");

$idCandidato = $_SESSION['id'];

// Define o cabeçalho como JSON
header('Content-Type: application/json');

// Captura o candidato via GET ou usa o ID da sessão
$candidato = isset($_GET["id"]) ? $_GET["id"] : $idCandidato;

try {
    // Consultar candidaturas
    $query = $pdo->prepare("SELECT * FROM candidaturas WHERE candidato = :candidato ORDER BY id DESC");
    $query->bindParam(':candidato', $candidato, PDO::PARAM_INT);
    $query->execute();
    $candidaturas = $query->fetchAll(PDO::FETCH_ASSOC);

    $resultado = [];

    foreach ($candidaturas as $candidatura) {
        $candidatoId = $candidatura['candidato'];
        $vagaId = $candidatura['vaga'];
        $statusCandidatura = $candidatura['status'];

        // Buscar informações do candidato
        $query = $pdo->prepare("SELECT nome FROM candidatos WHERE id = :candidatoId");
        $query->bindParam(':candidatoId', $candidatoId, PDO::PARAM_INT);
        $query->execute();
        $candidatoVisu = $query->fetch(PDO::FETCH_ASSOC);

        // Buscar informações da vaga
        $query = $pdo->prepare("SELECT titulo FROM vagas WHERE id = :vagaId");
        $query->bindParam(':vagaId', $vagaId, PDO::PARAM_INT);
        $query->execute();
        $vagaVisu = $query->fetch(PDO::FETCH_ASSOC);

        // Buscar informações do status
        $query = $pdo->prepare("SELECT nome FROM status_candidatura WHERE id = :statusCandidatura");
        $query->bindParam(':statusCandidatura', $statusCandidatura, PDO::PARAM_INT);
        $query->execute();
        $StatusVisu = $query->fetch(PDO::FETCH_ASSOC);

        // Monta o resultado para cada candidatura
        $resultado[] = [
            'id' => $candidatura['id'],
            'candidato' => $candidatoVisu['nome'] ?? 'N/A',
            'vaga' => $vagaVisu['titulo'] ?? 'N/A',
            'status' => $StatusVisu['nome'] ?? 'N/A'
        ];
    }

    // Retorna o resultado como JSON
    echo json_encode([
        'status' => 'success',
        'data' => $resultado
    ]);
} catch (PDOException $e) {
    // Em caso de erro, retorna uma resposta JSON
    echo json_encode([
        'status' => 'error',
        'message' => 'Erro na conexão com o banco de dados: ' . $e->getMessage()
    ]);
}
