<?php
session_start();
require_once("../includes/conecta.php");

header('Content-Type: application/json');

// Obtém o ID do questionário a partir dos parâmetros da URL
$questionarioId = "1";

if ($questionarioId <= 0) {
    echo json_encode(['error' => 'ID do questionário inválido']);
    exit;
}

try {

    // Buscar o questionário
    $stmt = $pdo->prepare("SELECT * FROM qst_questionarios WHERE qst_id = :id");
    $stmt->execute([':id' => $questionarioId]);
    $questionario = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$questionario) {
        echo json_encode(['error' => 'Questionário não encontrado']);
        exit;
    }

    // Buscar as perguntas do questionário
    $stmt = $pdo->prepare("SELECT * FROM qst_perguntas WHERE qst_id = :qst_id ORDER BY prg_id");
    $stmt->execute([':qst_id' => $questionarioId]);
    $perguntas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $resultados = [];

    foreach ($perguntas as $pergunta) {
        // Buscar respostas da pergunta
        $stmt = $pdo->prepare("SELECT * FROM qst_respostas WHERE prg_id = :prg_id ORDER BY rsp_id");
        $stmt->execute([':prg_id' => $pergunta['prg_id']]);
        $respostas = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $resultados[] = [
            'pergunta' => $pergunta,
            'respostas' => $respostas
        ];
    }

    // Retorna o resultado em formato JSON
    echo json_encode([
        'questionario' => $questionario,
        'perguntas' => $resultados
    ]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erro ao processar a requisição: ' . $e->getMessage()]);
}
