<?php
session_start();
require_once("../includes/conecta.php");

header('Content-Type: application/json');

// Verifica se o ID do candidato está definido na sessão
$idCandidato = $_SESSION['id'] ?? 0;

// Recebe os dados do POST
$nome = $_POST['nome'] ?? '';
$email = $_POST['email'] ?? '';
$telefone = $_POST['telefone'] ?? '';
$data_nascimento = $_POST['data_nascimento'] ?? '';
$data_nascimento_formatada = DateTime::createFromFormat('d/m/Y', $data_nascimento)->format('Y-m-d');
$cpf = $_POST['cpf'] ?? '';
$estado_civil = $_POST['estado_civil'] ?? '';
$escolaridade = $_POST['escolaridade'] ?? '';
$sexo = $_POST['sexo'] ?? '';
$empregado = $_POST['empregado'] ?? '';
$cep = $_POST['cep'] ?? '';
$rua = $_POST['rua'] ?? '';
$bairro = $_POST['bairro'] ?? '';
$cidade = $_POST['cidade'] ?? '';
$estado = $_POST['estado'] ?? '';
$numero = $_POST['numero'] ?? '';
$complemento = $_POST['complemento'] ?? '';
$experiencia_prof = $_POST['experiencia_prof'] ?? '';

// Senha nova e confirmação
$new_password = $_POST['password'] ?? ''; // Alterado de 'new_password' para 'password'
$confirm_password = $_POST['confirm_password'] ?? '';

// Mensagens de erro para senha
$new_password_err = '';
$confirm_password_err = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validar nova senha
    if (!empty($new_password)) {
        if (strlen(trim($new_password)) < 6) {
            $new_password_err = "A senha deve ter pelo menos 6 caracteres.";
        } else {
            $new_password = trim($new_password);
        }

        // Validar e confirmar a senha
        if (empty(trim($confirm_password))) {
            $confirm_password_err = "Por favor, confirme a senha.";
        } else {
            $confirm_password = trim($confirm_password);
            if (empty($new_password_err) && ($new_password != $confirm_password)) {
                $confirm_password_err = "A senha não confere.";
            }
        }
    }

    // Verifique os erros de entrada antes de atualizar o banco de dados
    if (empty($new_password_err) && empty($confirm_password_err)) {
        try {
            // Prepare a query de atualização
            $sql = "UPDATE candidatos SET 
                        nome = :nome,
                        email = :email,
                        telefone = :telefone,
                        data_nascimento = :data_nascimento,
                        cpf = :cpf,
                        estado_civil = :estado_civil,
                        escolaridade = :escolaridade,
                        sexo = :sexo,
                        empregado = :empregado,
                        cep = :cep,
                        rua = :rua,
                        bairro = :bairro,
                        cidade = :cidade,
                        estado = :estado,
                        numero = :numero,
                        complemento = :complemento,
                        experiencia_prof = :experiencia_prof";

            if (!empty($new_password)) {
                $sql .= ", password = :password";
            }
            $sql .= " WHERE id = :id";

            // Prepara a declaração
            $stmt = $pdo->prepare($sql);

            // Vincula as variáveis à instrução preparada como parâmetros
            $stmt->bindParam(':nome', $nome);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':telefone', $telefone);
            $stmt->bindParam(':data_nascimento', $data_nascimento_formatada);
            $stmt->bindParam(':cpf', $cpf);
            $stmt->bindParam(':estado_civil', $estado_civil);
            $stmt->bindParam(':escolaridade', $escolaridade);
            $stmt->bindParam(':sexo', $sexo);
            $stmt->bindParam(':empregado', $empregado);
            $stmt->bindParam(':cep', $cep);
            $stmt->bindParam(':rua', $rua);
            $stmt->bindParam(':bairro', $bairro);
            $stmt->bindParam(':cidade', $cidade);
            $stmt->bindParam(':estado', $estado);
            $stmt->bindParam(':numero', $numero);
            $stmt->bindParam(':complemento', $complemento);
            $stmt->bindParam(':experiencia_prof', $experiencia_prof);
            $stmt->bindParam(':id', $idCandidato, PDO::PARAM_INT);

            // Se a senha nova foi definida, adicione-a à declaração
            if (!empty($new_password)) {
                $param_password = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt->bindParam(':password', $param_password, PDO::PARAM_STR);
            }

            // Tente executar a declaração preparada
            if ($stmt->execute()) {
                $response = [
                    'status' => 'success', // Alterado de 'success' para 'status'
                    'message' => 'Registro atualizado com sucesso.'
                ];
            } else {
                $response = [
                    'status' => 'error', // Alterado de 'success' para 'status'
                    'message' => 'Ops! Algo deu errado. Por favor, tente novamente mais tarde.'
                ];
            }
        } catch (PDOException $e) {
            $response = [
                'status' => 'error', // Alterado de 'success' para 'status'
                'message' => 'Erro ao atualizar: ' . $e->getMessage()
            ];
        }
    } else {
        $response = [
            'status' => 'error', // Alterado de 'success' para 'status'
            'message' => $new_password_err ?: $confirm_password_err
        ];
    }
} else {
    $response = [
        'status' => 'error', // Alterado de 'success' para 'status'
        'message' => 'Método de requisição inválido.'
    ];
}

// Retorna a resposta em JSON
echo json_encode($response);
