<?php
session_start();
require_once("../includes/conecta.php");

$usuario_up_id = $_SESSION['id'] ?? 0;

$data = date('d/m/Y H:i'); // Obter a data formatada
$hash = hash('md5', $data); // Gerar um hash MD5 da data

$gerapixel = "_pixel_imagem_" . $hash . $usuario_up_id . "";

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Verifica se foi enviada uma imagem
    if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === UPLOAD_ERR_OK) {

        // Obtém informações sobre a imagem enviada
        $nome = $_FILES['imagem']['name'];
        $tipo = $_FILES['imagem']['type'];
        $tamanho = $_FILES['imagem']['size'];
        $temp = $_FILES['imagem']['tmp_name'];

        // Define o diretório de destino para a imagem
        $destino = '../images/usuarios/' . $usuario_up_id . $gerapixel . $nome;

        $extensao = pathinfo($destino, PATHINFO_EXTENSION);
        $destino = pathinfo($destino, PATHINFO_FILENAME);
        $destino = preg_replace('/[^A-Za-z0-9\-]/', '', $destino);
        $destino = preg_replace('/[\-]+/', '-', $destino);
        $destino = str_replace(' ', '-', $destino);
        $destino = strtolower($destino);
        $destino = '../images/usuarios/' . $gerapixel . '.' . $extensao;

        // Redimensiona a imagem para um tamanho máximo de 800x800 pixels
        $img = imagecreatefromstring(file_get_contents($temp));
        if ($img !== false) {
            $largura = imagesx($img);
            $altura = imagesy($img);
            $max_largura = 800;
            $max_altura = 800;
            if ($largura > $max_largura || $altura > $max_altura) {
                $proporcao = min($max_largura / $largura, $max_altura / $altura);
                $nova_largura = round($proporcao * $largura);
                $nova_altura = round($proporcao * $altura);
                $nova_img = imagecreatetruecolor($nova_largura, $nova_altura);
                imagecopyresampled($nova_img, $img, 0, 0, 0, 0, $nova_largura, $nova_altura, $largura, $altura);
                imagedestroy($img);
                $img = $nova_img;
            }

            // Salva a imagem no diretório de destino
            imagejpeg($img, $destino);
            imagedestroy($img);

            // Atualiza o banco de dados
            $stmt = $pdo->prepare('SELECT foto FROM candidatos WHERE id = :id');
            $stmt->execute([':id' => $usuario_up_id]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                $stmt = $pdo->prepare('UPDATE candidatos SET foto = :foto WHERE id = :id');
                $stmt->execute([
                    ':id' => $usuario_up_id,
                    ':foto' => $destino
                ]);
            } else {
                $stmt = $pdo->prepare('INSERT INTO candidatos (id, foto) VALUES (:id, :foto)');
                $stmt->execute([
                    ':id' => $usuario_up_id,
                    ':foto' => $destino
                ]);
            }

            // Redireciona o usuário para a página de destino
            //header('Location: candidato_visu.php?status=ok&id=' . $usuario_up_id . '');
            exit;
        } else {
            echo "Erro ao processar a imagem.";
        }
    } else {
        echo "Erro no upload da imagem.";
    }
}
