<?php
require_once("../includes/conecta.php");

// Verificar se o token foi passado corretamente via GET
if (isset($_GET['token'])) {
    $token = $_GET['token'];

    // Preparar a consulta SQL para verificar a existência do token na tabela candidatos
    $sql = "SELECT * FROM candidatos WHERE token = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    // Verificar se encontrou algum registro com o token fornecido
    if ($result->num_rows > 0) {
        // Token encontrado, realizar o update para status_conta = 1
        $update_sql = "UPDATE candidatos SET status_conta = 1 WHERE token = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("s", $token);

        if ($update_stmt->execute()) {
            // Sucesso ao atualizar
            header("Location: $urlgeral . portal/login.php?valida=ok");
            exit(); // Certifique-se de que o script pare a execução após o redirecionamento
        } else {
            // Erro ao atualizar
            header("Location: $urlgeral . portal/login.php?valida=nao");
            exit();
        }
    } else {
        // Token não encontrado
        header("Location: $urlgeral . portal/login.php?valida=nao");
        exit();
    }

    // Fechar as conexões
    $stmt->close();
    $update_stmt->close();
    $conn->close();
} else {
    // Token não foi enviado
    header("Location: $urlgeral . portal/login.php?valida=nao");
    exit();
}
