<?php require_once("includes/topo.php");

//TOTAL DE CANDIDATOS
$query = $pdo->query("SELECT COUNT(*) as total FROM candidatos");
$resultadocandidatos = $query->fetch(PDO::FETCH_ASSOC);
$total_registros_candidatos = $resultadocandidatos['total'];
?>
<link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet">

<div class="content-body">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-3  col-lg-6 col-sm-6">
					<div class="widget-stat card">
						<div class="card-body p-4">
							<div class="media ai-icon">
								<span class="me-3 bgl-primary text-primary">
									<!-- <i class="ti-user"></i> -->
									<i class="bi bi-file-earmark-person"></i>
								</span>
								<div class="media-body">
									<p class="mb-1">Candidatos</p>
									<h4 class="mb-0"><?php echo $total_registros_candidatos; ?></h4>

								</div>
							</div>
						</div>
					</div>
			</div>
			<!--
			<div class="col-xl-6 col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Estatísticas por idade</h4>
                                    </div>
                                    <div class="card-body">
                                        <div id="morris_donught" class="morris_chart_height"></div>
                                    </div>
                                </div>
                            </div>
                            -->
            <div class="col-xl-12">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Candidatos</h4>
                                <a href="candidatos_add.php" class="btn btn-primary btn-sm">Adicionar candidato</a>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="candidatos-table" class="table table-responsive-md">
                                        <thead>
                                            <tr>
                                                <th style="width:50px;">
                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                        <label class="form-check-label" for="checkAll"></label>
                                                    </div>
                                                </th>
                                                <th><strong>Carimbo</strong></th>
                                                <th><strong>Nome</strong></th>
                                                <th><strong>Data Nasc</strong></th>
                                                <th><strong>Usuário</strong></th>
                                                <th><strong>Status</strong></th>
                                                <th><strong>Ações</strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Os dados serão carregados via AJAX -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once("includes/rodape.php"); ?>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="./vendor/morris/morris.min.js"></script>
    <script src="./js/plugins-init/morris-init.js"></script>
    
    
<script>
    $(document).ready(function() {
        // Faz uma chamada AJAX para obter os dados das idades
        $.ajax({
            url: 'chart_idade.php', // Substitua pelo caminho do seu script PHP que executa a query
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                // Chama a função para desenhar o gráfico de donut
                donutChart(data);
            }
        });
    });

    var donutChart = function(data) {
        Morris.Donut({
            element: 'morris_donught',
            data: data,
            resize: true,
            redraw: true,
            colors: ['#9568ff', 'rgb(255, 92, 0)', '#ffaa2b'],
        });
    }
</script>    
    
<script>
    $(document).ready(function() {
        $('#candidatos-table').DataTable({
            "processing": true,    // Ativa a visualização de processamento
            "serverSide": true,    // Ativa o processamento do lado do servidor
            "ajax": {
                "url": "candidatos_fetch.php", // URL para a requisição AJAX
                "type": "POST"
            },
            "columns": [
                { "data": null, render: function(data, type, row, meta) { return '<div class="form-check custom-checkbox checkbox-success check-lg me-3"><input type="checkbox" class="form-check-input" id="customCheckBox'+meta.row+'" required=""><label class="form-check-label" for="customCheckBox'+meta.row+'"></label></div>'; }},
                { "data": "carimbo_data_hota" },
                { "data": "nome" },
                { "data": "data_nascimento" },
                { "data": "email" },
                { "data": "status" },
                { "data": "actions" }
            ],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/Portuguese-Brasil.json", // Tradução para Português
                "sProcessing":   "Processando...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Nenhum registro encontrado",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Buscar:",
                "sUrl":          "",
                "sInfoThousands":  ".",
                "sLoadingRecords": "Carregando...",
                "oPaginate": {
                    "sFirst":    "Pri",
                    "sLast":     "Últ",
                    "sNext":     "Pró",
                    "sPrevious": "Ant"
                },
                "oAria": {
                    "sSortAscending":  ": Ative para classificar a coluna em ordem crescente",
                    "sSortDescending": ": Ative para classificar a coluna em ordem decrescente"
                }
            }
        });
    });
</script>





<?php if (!empty($_GET['status']) == "ok") { ?>
    <script>
        window.onload = function() {
            swal({
                title: 'Sucesso',
                text: ("Candidato criado com sucesso!"),
                type: 'success',
                confirmButtonText: 'Fechar'
            })
        };
    </script>
<?php } ?>

<?php if (!empty($_GET['apagou']) == "ok") { ?>
    <script>
        window.onload = function() {
            swal({
                title: 'Candidato apagado!',
                text: ("Candidato apagado com sucesso!"),
                type: 'success',
                confirmButtonText: 'Fechar'
            })
        };
    </script>
<?php } ?>
