<?php
require_once("includes/topo.php");  ?>

<div class="content-body">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="row">

                    <div class="col-xl-12 col-lg-12">
                        <a href="candidatos.php" class="btn btn-primary btn-sm">Voltar</a>
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Adicionar novo candidato</h4>

                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form id="candidatoForm">
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label">Nome</label>
                                            <div class="col-sm-9">
                                                <input type="text" name="nome" class="form-control" placeholder="Nome" required>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label">E-mail</label>
                                            <div class="col-sm-9">
                                                <input type="email" name="email" class="form-control" placeholder="Email" required>
                                                <span class="invalid-feedback"></span>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label">Senha</label>
                                            <div class="col-sm-9">
                                                <input type="password" name="password" class="form-control" placeholder="Senha" required>
                                                <span class="invalid-feedback"></span>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label">Confirmar senha</label>
                                            <div class="col-sm-9">
                                                <input type="password" name="confirm_password" class="form-control" placeholder="Confirmar senha" required>
                                                <span class="invalid-feedback"></span>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <div class="col-sm-10">
                                                <button type="submit" class="btn btn-primary">Criar candidato</button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<?php require_once("includes/rodape.php");  ?>

<script>
    $(document).ready(function() {
        $("#candidatoForm").on("submit", function(e) {
            e.preventDefault();

            // Limpa estados anteriores
            $('input').removeClass('is-invalid');
            $('.invalid-feedback').hide();

            $.ajax({
                url: 'includes/add_candidato.php?candidato=1',
                type: 'POST',
                dataType: 'json', // Espera JSON do servidor
                data: $(this).serialize(),
                success: function(response) {
                    if (response.status === 'success') {
                        window.location.href = 'candidatos.php?status=ok';
                    } else {
                        // Tratamento de erros
                        if (response.username_err) {
                            $('input[name="email"]').addClass('is-invalid');
                            $('input[name="email"]').siblings('.invalid-feedback').text(response.username_err).show();
                        }
                        if (response.password_err) {
                            $('input[name="password"]').addClass('is-invalid');
                            $('input[name="password"]').siblings('.invalid-feedback').text(response.password_err).show();
                        }
                        if (response.confirm_password_err) {
                            $('input[name="confirm_password"]').addClass('is-invalid');
                            $('input[name="confirm_password"]').siblings('.invalid-feedback').text(response.confirm_password_err).show();
                        }
                    }
                },
                error: function(xhr, status, error) {
                    alert('Erro ao criar candidato: ' + xhr.responseText);
                }
            });
        });
    });
</script>