<?php
require_once('includes/conecta.php');

// Ler parâmetros do DataTables
$draw = $_POST['draw'];
$start = $_POST['start'];
$length = $_POST['length'];
$searchValue = $_POST['search']['value']; // Valor de busca

// Contar total de registros
$totalQuery = $pdo->query("SELECT COUNT(*) AS total FROM candidatos");
$totalData = $totalQuery->fetch(PDO::FETCH_ASSOC);
$totalRecords = $totalData['total'];

// Preparar a consulta
$query = "SELECT * FROM candidatos WHERE 1";

// Adicionar filtro de pesquisa
if (!empty($searchValue)) {
    $query .= " AND (nome LIKE :search OR email LIKE :search)";
}

// Obter a contagem total após o filtro
$totalFilteredQuery = $pdo->prepare($query);
if (!empty($searchValue)) {
    $totalFilteredQuery->bindValue(':search', '%' . $searchValue . '%');
}
$totalFilteredQuery->execute();
$totalFiltered = $totalFilteredQuery->rowCount();

// Adicionar LIMIT para paginação
$query .= " ORDER BY id DESC LIMIT :start, :length";
$paginatedQuery = $pdo->prepare($query);
$paginatedQuery->bindValue(':start', (int)$start, PDO::PARAM_INT);
$paginatedQuery->bindValue(':length', (int)$length, PDO::PARAM_INT);
if (!empty($searchValue)) {
    $paginatedQuery->bindValue(':search', '%' . $searchValue . '%');
}
$paginatedQuery->execute();
$candidatos = $paginatedQuery->fetchAll(PDO::FETCH_ASSOC);

// Preparar dados para o formato JSON
$data = [];
foreach ($candidatos as $candidato) {
    $data_nascimento = date("d/m/Y", strtotime($candidato['data_nascimento'])); // Converte a data para o formato desejado
    
    // Limpa o número de telefone, removendo caracteres indesejados
    $telefone = preg_replace('/[^0-9]/', '', $candidato['telefone']);
     // Formata a data do carimbo
     if ($candidato['carimbo_data_hota'] && $candidato['carimbo_data_hota'] !== '0000-00-00 00:00:00') {
        $carimbo_data_hota = date("d/m/Y H:i:s", strtotime($candidato['carimbo_data_hota'])); // Converte a data do carimbo para o formato desejado com horas
    } else {
        $carimbo_data_hota = 'Não definido'; // Define como "Não definido" se o valor for inválido
    }
    
    if ($candidato['tipo_dado'] == "3") {
        $tipo_dado = " <span style='font-size:10px'> - Importado</span>";   
    } else {
        $tipo_dado = ""; 
    }

    // Gera a ação com os botões
    $actions = '<a href="candidato_visu.php?id=' . $candidato['id'] . '" class="btn btn-primary shadow btn-xs sharp me-1"><i class="fa fa-pencil"></i></a>';
    // Adiciona o botão do WhatsApp
    if (!empty($telefone)) {
        $actions .= '<a href="https://wa.me/55' . $telefone . '" target="_blank" class="btn btn-success shadow btn-xs sharp me-1"><i class="fab fa-whatsapp"></i></a>';
    }
    // Adiciona o botão de download do currículo anexo se existir
    if (!empty($candidato['curriculo_anexo'])) {
        $actions .= '<a href="' . $candidato['curriculo_anexo'] . '" target="_blank" class="btn btn-info shadow btn-xs sharp me-1"><i class="fa fa-file-pdf"></i></a>';
    }
    
    // Verifica o status da conta
    $status_conta = $candidato['status_conta'] == 1 ? 'Ativo' : 'Inativo';

    $data[] = [
        "carimbo_data_hota" => $carimbo_data_hota,
        "nome" => $candidato['nome'],
        "data_nascimento" => $data_nascimento,
        "email" => $candidato['email'],
        "status" => '<div class="d-flex align-items-center"><i class="fa fa-circle text-' . ($candidato['status_conta'] == 1 ? 'success' : 'danger') . ' me-1"></i> ' . $status_conta . $tipo_dado . '</div>',
        "actions" => $actions // As ações agora incluem o botão do WhatsApp
    ];
}

// Retornar o JSON
$response = [
    "draw" => intval($draw),
    "recordsTotal" => intval($totalRecords),
    "recordsFiltered" => intval($totalFiltered),
    "data" => $data
];

echo json_encode($response);
?>
