<?php require_once("includes/topo.php");  ?>

<div class="content-body">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="row">


                    <div class="col-lg-12">

                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Candidaturas</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-responsive-md">
                                        <thead>
                                            <tr>
                                                <th style="width:50px;">
                                                    <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                        <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                        <label class="form-check-label" for="checkAll"></label>
                                                    </div>
                                                </th>
                                                <th><strong>ID</strong></th>
                                                <th><strong>Nome</strong></th>
                                                <th><strong>Vaga</strong></th>
                                                <th><strong>Status</strong></th>
                                                <th><strong></strong></th>
                                            </tr>
                                        </thead>
                                        <tbody>


                                            <?php
                                            // Candidaturas
                                            $vaga = isset($_GET["id"]) ? $_GET["id"] : NULL;

                                            if ($vaga === NULL) {
                                                $fill = "";
                                            } else {
                                                $fill = "WHERE vaga = " . intval($vaga); // Usar intval para evitar SQL Injection
                                            }
                                            // Consultar candidaturas
                                            $query = $pdo->query("SELECT * FROM candidaturas $fill ORDER BY id DESC");
                                            $candidaturas = $query->fetchAll(PDO::FETCH_ASSOC);

                                            foreach ($candidaturas as $candidatura) {

                                                $candidatoId = $candidatura['candidato'];
                                                $vagaId = $candidatura['vaga'];
                                                $statusCandidatura = $candidatura['status'];

                                                $query = $pdo->query("SELECT * FROM candidatos WHERE id = $candidatoId");
                                                $candidatoVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                                $query = $pdo->query("SELECT * FROM vagas WHERE id = $vagaId");
                                                $vagaVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                                $query = $pdo->query("SELECT * FROM status_candidatura WHERE id = $statusCandidatura");
                                                $StatusVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                                $corStatus = "";
                                                if ($statusCandidatura == 1) {
                                                    $corStatus = "#f49821";
                                                }
                                                if ($statusCandidatura == 2) {
                                                    $corStatus = "#9568ff";
                                                }
                                                if ($statusCandidatura == 3) {
                                                    $corStatus = "#00b8ef";
                                                }
                                                if ($statusCandidatura == 4) {
                                                    $corStatus = "#00a389";
                                                }
                                                if ($statusCandidatura == 5) {
                                                    $corStatus = "#eb5757";
                                                }


                                            ?>
                                                <tr>
                                                    <td>
                                                        <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                            <input type="checkbox" class="form-check-input" id="customCheckBox<?php echo $candidatura['id']; ?>" required="">
                                                            <label class="form-check-label" for="customCheckBox<?php echo $candidatura['id']; ?>"></label>
                                                        </div>
                                                    </td>
                                                    <td><strong><?php echo $candidatura['id']; ?></strong></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <a href="candidaturas_visu.php?id=<?php echo $candidatura['candidato']; ?>">
                                                                <span class="w-space-no"><?php echo $candidatoVisu[0]['nome'] ?></span>
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $vagaVisu[0]['titulo']; ?></td>
                                                    <td>
                                                        <span style="color:<?php echo $corStatus; ?>"><?php echo $StatusVisu[0]['nome'] ?></span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex">
                                                            <a href="candidaturas_visu.php?id=<?php echo $candidatura['candidato']; ?>" class="btn btn-primary shadow btn-xs sharp me-1"><i class="fa fa-pencil"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>




                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>





                </div>
            </div>

        </div>
    </div>
</div>

<?php require_once("includes/rodape.php"); ?>



<?php if (!empty($_GET['status']) == "ok") { ?>
    <script>
        window.onload = function() {
            swal({
                title: 'Sucesso',
                text: ("Empresa criada com sucesso!"),
                type: 'success',
                confirmButtonText: 'Fechar'
            })
        };
    </script>
<?php } ?>

<?php if (!empty($_GET['apagou']) == "ok") { ?>
    <script>
        window.onload = function() {
            swal({
                title: 'Empresa apagada!',
                text: ("Empresa apagada com sucesso!"),
                type: 'success',
                confirmButtonText: 'Fechar'
            })
        };
    </script>
<?php } ?>