<?php require_once("includes/topo.php");

$usuario_id = $_GET["id"];
$queryUser = $pdo->query("SELECT * FROM candidatos WHERE id = $usuario_id");
$candidatoFull = $queryUser->fetchAll(PDO::FETCH_ASSOC);


$nomeCompleto = $candidatoFull[0]['nome'];
$partesNome = explode(' ', $nomeCompleto);
$primeiroNome = $partesNome[0];


?>
<div class="content-body">

    <!-- row -->
    <div class="container-fluid">
        <div class="row">

            <h3>Dados <strong>analíticos</strong> do candidato <strong><?php echo htmlspecialchars($primeiroNome); ?></strong>:</h3>

            <div class="col-xl-12">
                <div class="row">
                    <div class="col-xl-3 col-lg-6 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="students1 d-flex align-items-center justify-content-between flex-wrap">
                                    <div>
                                        <h5>Resposta A</h5>
                                        <h4 id="respostaA_valor">0</h4> <!-- Valor da Resposta A -->
                                    </div>
                                    <div>
                                        <div class="d-inline-block position-relative donut-chart-sale mb-3">
                                            <span class="donut1" id="respostaA_percentual">0/100</span> <!-- Percentual da Resposta A -->
                                            <small id="respostaA_small">0%</small> <!-- Percentual exibido de Resposta A -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="students1 d-flex align-items-center justify-content-between flex-wrap">
                                    <div>
                                        <h5>Resposta B</h5>
                                        <h4 id="respostaB_valor">0</h4> <!-- Valor da Resposta B -->
                                    </div>
                                    <div>
                                        <div class="d-inline-block position-relative donut-chart-sale mb-3">
                                            <span class="donut1" id="respostaB_percentual">0/100</span> <!-- Percentual da Resposta B -->
                                            <small id="respostaB_small">0%</small> <!-- Percentual exibido de Resposta B -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="students1 d-flex align-items-center justify-content-between flex-wrap">
                                    <div>
                                        <h5>Resposta C</h5>
                                        <h4 id="respostaC_valor">0</h4> <!-- Valor da Resposta C -->
                                    </div>
                                    <div>
                                        <div class="d-inline-block position-relative donut-chart-sale mb-3">
                                            <span class="donut1" id="respostaC_percentual">0/100</span> <!-- Percentual da Resposta C -->
                                            <small id="respostaC_small">0%</small> <!-- Percentual exibido de Resposta C -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="students1 d-flex align-items-center justify-content-between flex-wrap">
                                    <div>
                                        <h5>Resposta D</h5>
                                        <h4 id="respostaD_valor">0</h4> <!-- Valor da Resposta D -->
                                    </div>
                                    <div>
                                        <div class="d-inline-block position-relative donut-chart-sale mb-3">
                                            <span class="donut1" id="respostaD_percentual">0/100</span> <!-- Percentual da Resposta D -->
                                            <small id="respostaD_small">0%</small> <!-- Percentual exibido de Resposta D -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-xl-3 col-lg-4">
                <div class="clearfix">
                    <div class="card card-bx profile-card author-profile m-b30">
                        <div class="card-body">
                            <div class="p-5">
                                <div class="author-profile">
                                    <div class="author-media">
                                        <img src="<?php echo $candidatoFull[0]['foto']; ?>" alt="">
                                    </div>
                                    <div class="author-info">
                                        <h3 class=""><?php echo $candidatoFull[0]['nome'] ?></h3>
                                        <span>Developer</span>
                                    </div>
                                </div>
                            </div>
                            <div class="info-list">
                                <ul>
                                    <li>Tel <span><?php echo $candidatoFull[0]['telefone']; ?></span></li>
                                    <li>Email <span><?php echo $candidatoFull[0]['email']; ?></span></li>
                                    <li>Data Nasc <span><?php echo $candidatoFull[0]['data_nascimento']; ?></span></li>
                                    <li>Nacionalidade <span><?php echo $candidatoFull[0]['nacionalidade']; ?></span></li>
                                    <li>Estado civil <span><?php echo $candidatoFull[0]['estado_civil']; ?></span></li>
                                    <li>Escolaridade <span><?php echo $candidatoFull[0]['escolaridade']; ?></span></li>
                                    <li>Sexo <span><?php echo $candidatoFull[0]['sexo']; ?></span></li>
                                    <li>Empregado <span><?php echo $candidatoFull[0]['empregado']; ?></span></li>
                                </ul>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


            <div class="col-xl-9">

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Candidaturas</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-responsive-md">
                                <thead>
                                    <tr>
                                        <th style="width:50px;">
                                            <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                <input type="checkbox" class="form-check-input" id="checkAll" required="">
                                                <label class="form-check-label" for="checkAll"></label>
                                            </div>
                                        </th>
                                        <th><strong>ID</strong></th>
                                        <th><strong>Nome</strong></th>
                                        <th><strong>Vaga</strong></th>
                                        <th><strong>Status</strong></th>
                                        <th><strong>Observações</strong></th>
                                        <th><strong></strong></th>
                                    </tr>
                                </thead>
                                <tbody>


                                    <?php
                                    // Candidaturas
                                    $candidato = isset($_GET["id"]) ? $_GET["id"] : NULL;


                                    // Consultar candidaturas
                                    $query = $pdo->query("SELECT * FROM candidaturas where candidato = $candidato ORDER BY id DESC");
                                    $candidaturas = $query->fetchAll(PDO::FETCH_ASSOC);

                                    foreach ($candidaturas as $candidatura) {

                                        $candidatoId = $candidatura['candidato'];
                                        $vagaId = $candidatura['vaga'];
                                        $statusCandidatura = $candidatura['status'];

                                        $query = $pdo->query("SELECT * FROM candidatos WHERE id = $candidatoId");
                                        $candidatoVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                        $query = $pdo->query("SELECT * FROM vagas WHERE id = $vagaId");
                                        $vagaVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                        $query = $pdo->query("SELECT * FROM status_candidatura WHERE id = $statusCandidatura");
                                        $StatusVisu = $query->fetchAll(PDO::FETCH_ASSOC);

                                        $corStatus = "";
                                        if ($statusCandidatura == 1) {
                                            $corStatus = "#f49821";
                                        }
                                        if ($statusCandidatura == 2) {
                                            $corStatus = "#9568ff";
                                        }
                                        if ($statusCandidatura == 3) {
                                            $corStatus = "#00b8ef";
                                        }
                                        if ($statusCandidatura == 4) {
                                            $corStatus = "#00a389";
                                        }
                                        if ($statusCandidatura == 5) {
                                            $corStatus = "#eb5757";
                                        }

                                    ?>
                                        <tr>
                                            <td>
                                                <div class="form-check custom-checkbox checkbox-success check-lg me-3">
                                                    <input type="checkbox" class="form-check-input" id="customCheckBox<?php echo $candidatura['id']; ?>" required="">
                                                    <label class="form-check-label" for="customCheckBox<?php echo $candidatura['id']; ?>"></label>
                                                </div>
                                            </td>
                                            <td><strong><?php echo $candidatura['id']; ?></strong></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="w-space-no"><?php echo $candidatoVisu[0]['nome'] ?></span>
                                                </div>
                                            </td>
                                            <td><a href="#" data-bs-toggle="modal" id="<?php echo $vagaId; ?>" data-bs-target=".bd-example-modal-lg" data-id="<?php echo $vagaId; ?>"><i class="fa fa-eye"></i> <?php echo $vagaVisu[0]['titulo']; ?></a> </td>
                                            <td>
                                                <span style="color:<?php echo $corStatus; ?>"><?php echo $StatusVisu[0]['nome'] ?></span>
                                            </td>
                                            <td>
                                                <?php echo $candidatura['obs_recrutador']; ?>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a href="#" class="btn btn-primary shadow btn-xs sharp me-1" onclick="alterarStatus(<?php echo $candidatura['id']; ?>); return false;">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>

                                                </div>
                                            </td>
                                        </tr>


                                    <?php } ?>



                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>












        </div>
    </div>
</div>


<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" id="myModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Dados da vaga</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Dados carregados via AJAX serão inseridos aqui -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger light" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="statusModalLabel">Alterar Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="statusForm">
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select id="status" class="form-select" required>
                            <option value="">Selecione o status</option>
                            <option value="1">Em análise</option>
                            <option value="2">Selecionado</option>
                            <option value="3">Entrevista Técnica</option>
                            <option value="4">Aprovado</option>
                            <option value="5">Reprovado</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="obs_recrutador" class="form-label">Observação</label>
                        <textarea id="obs_recrutador" class="form-control" style="height: 150px;" placeholder="Observação"></textarea>
                    </div>
                    <input type="hidden" id="modalId" />
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="saveChanges">Salvar</button>
            </div>
        </div>
    </div>
</div>

<?php require_once("includes/rodape.php"); ?>

<script src="vendor/global/global.min.js"></script>
<script src="vendor/peity/jquery.peity.min.js"></script>
<script src="js/plugins-init/widgets-script-init.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var modalElement = document.querySelector('.bd-example-modal-lg');
        var modal = new bootstrap.Modal(modalElement);

        modalElement.addEventListener('show.bs.modal', function(event) {
            // Pegue o link que abriu o modal
            var button = event.relatedTarget;
            // Pegue o ID do botão
            var id = button.getAttribute('data-id');

            // Faça uma requisição AJAX para buscar os dados com base no ID
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'includes/busca_vaga.php?id=' + id, true);
            xhr.onload = function() {
                if (xhr.status >= 200 && xhr.status < 400) {
                    // Supondo que a resposta seja JSON
                    var response = JSON.parse(xhr.responseText);
                    // Atualize o modal com os dados
                    var modalBody = modalElement.querySelector('.modal-body');
                    if (response.length > 0) {
                        var vaga = response[0];
                        modalBody.innerHTML = `
                        <h5>${vaga.titulo}</h5>
                        <p>
                        <strong>Status:</strong> ${vaga.status || 'Status não disponível'}<br>
                        <strong>Salário:</strong> ${vaga.salario || 'Salário não disponível'}<br>
                        <strong>Requisitos:</strong> ${vaga.requisitos || 'Requisito não disponível'}<br>
                        <strong>Benefícios:</strong> ${vaga.beneficios || 'Benefícios não disponíveis'}<br>
                        <strong>Vagas:</strong> ${vaga.quantidade || 'Vagas não disponíveis'}<br><br>
                        <strong>Descrição:</strong> ${vaga.descricao || 'Descrição não disponível'}
                        
                        
                        </p>
                    `;
                    } else {
                        modalBody.innerHTML = 'Nenhum dado encontrado para este ID.';
                    }
                } else {
                    console.error('Erro na requisição AJAX');
                }
            };
            xhr.onerror = function() {
                console.error('Erro na requisição AJAX');
            };
            xhr.send();
        });
    });
</script>


<script>
    function alterarStatus(id) {
        // Preencher o ID no campo oculto do modal
        document.getElementById('modalId').value = id;

        // Exibir o modal
        var myModal = new bootstrap.Modal(document.getElementById('statusModal'));
        myModal.show();
    }

    // Evento de clique no botão Salvar
    document.getElementById('saveChanges').addEventListener('click', function() {
        const id = document.getElementById('modalId').value;
        const status = document.getElementById('status').value;
        const obs_recrutador = document.getElementById('obs_recrutador').value;

        if (!status) {
            alert('Por favor, selecione um status');
            return;
        }

        // Fazer a chamada AJAX
        $.ajax({
            url: 'includes/class_candidaturas.php',
            type: 'POST',
            data: {
                candidaturas: 1,
                id: id,
                status: status,
                obs_recrutador: obs_recrutador
            },
            dataType: 'json',
            success: function(response) {
                console.log('Resposta do servidor:', response);
                if (response && response.success) {
                    // Mostrar SweetAlert de sucesso
                    Swal.fire({
                        title: 'Sucesso!',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        // Atualizar a página após o sucesso
                        location.reload();
                    });
                } else {
                    Swal.fire('Erro', (response && response.message) || 'Erro ao atualizar o status', 'error');
                }
                // Fechar o modal
                var myModalEl = document.getElementById('statusModal');
                var modal = bootstrap.Modal.getInstance(myModalEl);
                modal.hide();
            },
            error: function(xhr, status, error) {
                console.error('Erro AJAX:', xhr.responseText);
                console.error('Status:', status);
                console.error('Error:', error);
                Swal.fire('Erro', 'Erro ao comunicar com o servidor', 'error');
                // Fechar o modal
                var myModalEl = document.getElementById('statusModal');
                var modal = bootstrap.Modal.getInstance(myModalEl);
                modal.hide();
            }
        });
    });

    // Adicione este código para vincular a função ao botão
    document.addEventListener('DOMContentLoaded', function() {
        const buttons = document.querySelectorAll('.alterar-status-btn');
        buttons.forEach(button => {
            button.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                alterarStatus(id);
            });
        });
    });
</script>





<script>
    $(document).ready(function() {
        // ID do candidato
        var usuario_id = "<?php echo $usuario_id; ?>"; // Exemplo de ID do candidato

        // Fazendo a requisição AJAX
        $.ajax({
            url: "<?php echo $urlgeral ?>painel/api/contagem_candidato.php",
            type: "GET",
            data: {
                pessoa_id: usuario_id
            },
            dataType: "json",
            success: function(contagem) {
                if (contagem) {
                    // Evita divisão por zero
                    var total = parseInt(contagem.total) || 1;

                    // Calculando e atualizando a Resposta A
                    var countA = parseInt(contagem.count_a) || 0;
                    var percentualA = Math.round((countA / total) * 100);
                    $('#respostaA_valor').text(countA);
                    $('#respostaA_percentual').text(percentualA + '/100');
                    $('#respostaA_small').text(percentualA + '%');

                    // Calculando e atualizando a Resposta B
                    var countB = parseInt(contagem.count_b) || 0;
                    var percentualB = Math.round((countB / total) * 100);
                    $('#respostaB_valor').text(countB);
                    $('#respostaB_percentual').text(percentualB + '/100');
                    $('#respostaB_small').text(percentualB + '%');

                    // Calculando e atualizando a Resposta C
                    var countC = parseInt(contagem.count_c) || 0;
                    var percentualC = Math.round((countC / total) * 100);
                    $('#respostaC_valor').text(countC);
                    $('#respostaC_percentual').text(percentualC + '/100');
                    $('#respostaC_small').text(percentualC + '%');

                    // Calculando e atualizando a Resposta D
                    var countD = parseInt(contagem.count_d) || 0;
                    var percentualD = Math.round((countD / total) * 100);
                    $('#respostaD_valor').text(countD);
                    $('#respostaD_percentual').text(percentualD + '/100');
                    $('#respostaD_small').text(percentualD + '%');
                }
            },
            error: function(xhr, status, error) {
                console.log("Erro na consulta: ", error);
            }
        });
    });
</script>