<?php
require_once('includes/conecta.php');

// Executa a consulta para pegar as idades, ignorando datas inválidas
$query = "SELECT FLOOR(DATEDIFF(CURDATE(), data_nascimento) / 365) AS idade, COUNT(*) AS quantidade 
          FROM candidatos 
          WHERE data_nascimento != '0000-00-00' AND data_nascimento IS NOT NULL
          GROUP BY idade 
          ORDER BY idade";

$stmt = $pdo->prepare($query);
$stmt->execute();

// Prepara os dados para o gráfico
$dados_idade = [];
$total_candidatos = 0;

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $dados_idade[$row['idade']] = $row['quantidade'];
    $total_candidatos += $row['quantidade'];
}

// Calcula a porcentagem para cada idade
$percentuais = [];
if ($total_candidatos > 0) {
    foreach ($dados_idade as $idade => $quantidade) {
        $percentual = ($quantidade / $total_candidatos) * 100;
        $percentuais[] = [
            'label' => $idade . ' anos',
            'value' => number_format($percentual, 2, '.', '')
        ];
    }
}

// Retorna os dados em formato JSON para o JavaScript
echo json_encode($percentuais);
?>