<!DOCTYPE html>
<html>
<head>
  <title>Fluid Simulation</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
  <canvas id="fluid-canvas"></canvas>
  <script src="https://cdn.jsdelivr.net/npm/fluid-simulation@2.2.1/dist/fluid-simulation.min.js"></script>
  <script>
    const canvas = document.getElementById('fluid-canvas');
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    const simulation = new FluidSimulation({
      size: [canvas.width, canvas.height],
      resolution: 1,
      backgroundColor: [0, 0, 0, 1],
      debug: false,
    });
    simulation.addObstacle({
      x: canvas.width / 2,
      y: canvas.height / 2,
      radius: 50,
      strength: 10,
    });
    function render() {
      simulation.update();
      simulation.render();
      requestAnimationFrame(render);
    }
    render();
  </script>
</body>
</html>
