<?php
// Configurações da miniatura
$thumb_width = $_GET['w'];
$thumb_height = $_GET['h'];

// Obtém o URL da imagem original
$image_url = $_GET['url'];

// Obtém a extensão do arquivo de imagem
$extension = strtolower(pathinfo($image_url, PATHINFO_EXTENSION));

// Define o tipo MIME da imagem de saída
header('Content-Type: images/' . $extension);

// Cria uma nova imagem a partir do arquivo original
switch ($extension) {
    case 'jpg':
    case 'jpeg':
        $img = imagecreatefromjpeg($image_url);
        break;
    case 'png':
        $img = imagecreatefrompng($image_url);
        break;
    case 'gif':
        $img = imagecreatefromgif($image_url);
        break;
    default:
        die('Invalid image type');
}

// Obtém as dimensões da imagem original
$width = imagesx($img);
$height = imagesy($img);

// Calcula as dimensões da miniatura
$thumb_width = $thumb_height = min($width, $height);

// Cria uma nova imagem em branco para a miniatura
$thumb = imagecreatetruecolor($thumb_width, $thumb_height);

// Calcula as coordenadas para cortar a imagem original centralizada
$crop_x = ($width - $thumb_width) / 2;
$crop_y = ($height - $thumb_height) / 2;

// Copia a área da imagem original correspondente à miniatura para a nova imagem
imagecopy($thumb, $img, 0, 0, $crop_x, $crop_y, $thumb_width, $thumb_height);

// Envia a miniatura para o navegador
switch ($extension) {
    case 'jpg':
    case 'jpeg':
        imagejpeg($thumb);
        break;
    case 'png':
        imagepng($thumb);
        break;
    case 'gif':
        imagegif($thumb);
        break;
}

// Libera a memória usada pelas imagens
imagedestroy($img);
imagedestroy($thumb);
?>
