<?php
require_once('conecta.php');

// Defina variáveis e inicialize com valores vazios
$username = $nome = $password = $confirm_password = "";
$username_err = $nome_err = $password_err = $confirm_password_err = "";
$foto_avatar = "images/usuarios/pixel.png";

// Processando dados do formulário quando o formulário é enviado
if ($_GET['candidato'] == 1) {

    // Validar nome de usuário (e-mail)
    if (empty(trim($_POST["email"]))) {
        $username_err = "Por favor, coloque um e-mail.";
    } elseif (!filter_var(trim($_POST["email"]), FILTER_VALIDATE_EMAIL)) {
        $username_err = "O e-mail inserido não é válido.";
    } else {
        // Prepare uma consulta para verificar se o e-mail já existe
        $sql = "SELECT id FROM candidatos WHERE email = :email";
        if ($stmt = $pdo->prepare($sql)) {
            $stmt->bindParam(":email", $param_username, PDO::PARAM_STR);
            $param_username = trim($_POST["email"]);

            if ($stmt->execute()) {
                if ($stmt->rowCount() == 1) {
                    $username_err = "Este e-mail já está em uso.";
                }
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Erro ao verificar e-mail.']);
                exit;
            }
            unset($stmt);
        }
    }

    // Validar senha
    if (empty(trim($_POST["password"]))) {
        $password_err = "Por favor, insira uma senha.";
    } elseif (strlen(trim($_POST["password"])) < 6) {
        $password_err = "A senha deve ter pelo menos 6 caracteres.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Confirmar senha
    if (empty(trim($_POST["confirm_password"]))) {
        $confirm_password_err = "Por favor, confirme a senha.";
    } else {
        $confirm_password = trim($_POST["confirm_password"]);
        if ($password != $confirm_password) {
            $confirm_password_err = "As senhas não coincidem.";
        }
    }

    // Verifique os erros antes de inserir no banco de dados
    if (empty($username_err) && empty($password_err) && empty($confirm_password_err)) {
        // Prepare a declaração de inserção
        $sql = "INSERT INTO candidatos (email, nome, foto, password) VALUES (:email, :nome, :foto, :password)";

        if ($stmt = $pdo->prepare($sql)) {
            $stmt->bindParam(":email", $param_username, PDO::PARAM_STR);
            $stmt->bindParam(":nome", $param_nome, PDO::PARAM_STR);
            $stmt->bindParam(":foto", $param_foto, PDO::PARAM_STR);
            $stmt->bindParam(":password", $param_password, PDO::PARAM_STR);

            // Definir os parâmetros
            $param_nome = trim($_POST["nome"]);
            $param_foto = $foto_avatar;
            $param_password = password_hash($password, PASSWORD_DEFAULT); // Hash da senha

            if ($stmt->execute()) {
                echo json_encode(['status' => 'success']);
                exit;
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Erro ao inserir no banco de dados.']);
                exit;
            }
            unset($stmt);
        }
    } else {
        // Retornar erros de validação
        echo json_encode([
            'status' => 'error',
            'username_err' => $username_err,
            'password_err' => $password_err,
            'confirm_password_err' => $confirm_password_err
        ]);
        exit;
    }

    unset($pdo);
}


if ($_GET['candidato'] == 2) {

    $user_id = $_GET["iduser"];

    // Delete the user with ID 123
    $sql = "DELETE FROM candidatos WHERE id = $user_id";
    if (mysqli_query($conn, $sql)) {
        header("location: ../candidatos.php?apagou=ok");
    } else {
        echo "Error deleting user: " . mysqli_error($conn);
    }
}
