<?php
require_once('conecta.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obter os dados enviados via AJAX
    $menuIds = $_POST['menuIds'];

    // Atualizar a ordem do menu no banco de dados
    foreach ($menuIds as $position => $menuId) {
        $sql = "UPDATE menus SET ordem = :position WHERE id = :menuId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':position', $position, PDO::PARAM_INT);
        $stmt->bindParam(':menuId', $menuId, PDO::PARAM_INT);

        try {
            $stmt->execute();
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            exit;
        }
    }

    echo json_encode(['success' => true]);
} else {
    // Requisição não é POST, retornar erro
    echo json_encode(['success' => false, 'message' => 'Requisição inválida']);
}
?>