<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>


<style>




.astronaut {
  position: absolute;
  z-index: 9;
  width: 185px;
  height: 300px;
  left: 45%;
  top: 27%;
  transform: translate(-50%, -50%) rotate(20deg) scale(1.2);
  
}

.box {
  transition: transform 0.5s ease-in-out;
}

.box:hover {
  transform: translateX(50px);
  transform: translateY(50px);
  transform: translateZ(50px);
}

.astronaut__head {
  background-color: white;
  position: absolute;
  top: 60px;
  left: 60px;
  width: 60px;
  height: 60px;
  content: '';
  border-radius: 2em;
}

.astronaut__head-visor-flare1 {
  background-color: #7f8fa6;
  position: absolute;
  top: 28px;
  left: 40px;
  width: 10px;
  height: 10px;
  content: '';
  border-radius: 2em;
  opacity: 0.5;
}

.astronaut__head-visor-flare2 {
  background-color: #718093;
  position: absolute;
  top: 40px;
  left: 38px;
  width: 5px;
  height: 5px;
  content: '';
  border-radius: 2em;
  opacity: 0.3;
}

.astronaut__backpack {
  background-color: #bfbfbf;
  position: absolute;
  top: 90px;
  left: 47px;
  width: 86px;
  height: 90px;
  content: '';
  border-radius: 8px;
}

.astronaut__body {
  background-color: #e6e6e6;
  position: absolute;
  top: 115px;
  left: 55px;
  width: 70px;
  height: 80px;
  content: '';
  border-radius: 8px;
}

.astronaut__body__chest {
  background-color: #d9d9d9;
  position: absolute;
  top: 140px;
  left: 68px;
  width: 45px;
  height: 25px;
  content: '';
  border-radius: 6px;
}

.astronaut__arm-left1 {
  background-color: #e6e6e6;
  position: absolute;
  top: 127px;
  left: 9px;
  width: 65px;
  height: 20px;
  content: '';
  border-radius: 8px;
  transform: rotate(-30deg);
}

.astronaut__arm-left2 {
  background-color: #e6e6e6;
  position: absolute;
  top: 102px;
  left: 7px;
  width: 20px;
  height: 45px;
  content: '';
  border-radius: 8px;
  transform: rotate(-12deg);
  border-top-left-radius: 8em;
  border-top-right-radius: 8em;
}

.astronaut__arm-right1 {
  background-color: #e6e6e6;
  position: absolute;
  top: 113px;
  left: 100px;
  width: 65px;
  height: 20px;
  content: '';
  border-radius: 8px;
  transform: rotate(-10deg);
}

.astronaut__arm-right2 {
  background-color: #e6e6e6;
  position: absolute;
  top: 78px;
  left: 141px;
  width: 20px;
  height: 45px;
  content: '';
  border-radius: 8px;
  transform: rotate(-10deg);
  border-top-left-radius: 8em;
  border-top-right-radius: 8em;
}

.astronaut__arm-thumb-left {
  background-color: #e6e6e6;
  position: absolute;
  top: 110px;
  left: 21px;
  width: 10px;
  height: 6px;
  content: '';
  border-radius: 8em;
  transform: rotate(-35deg);
}

.astronaut__arm-thumb-right {
  background-color: #e6e6e6;
  position: absolute;
  top: 90px;
  left: 133px;
  width: 10px;
  height: 6px;
  content: '';
  border-radius: 8em;
  transform: rotate(20deg);
}

.astronaut__wrist-left {
  background-color: #f49821;
  position: absolute;
  top: 122px;
  left: 6.5px;
  width: 21px;
  height: 4px;
  content: '';
  border-radius: 8em;
  transform: rotate(-15deg);
}

.astronaut__wrist-right {
  background-color: #f49821;
  position: absolute;
  top: 98px;
  left: 141px;
  width: 21px;
  height: 4px;
  content: '';
  border-radius: 8em;
  transform: rotate(-10deg);
}

.astronaut__leg-left {
  background-color: #e6e6e6;
  position: absolute;
  top: 188px;
  left: 50px;
  width: 23px;
  height: 75px;
  content: '';
  transform: rotate(10deg);
}

.astronaut__leg-right {
  background-color: #e6e6e6;
  position: absolute;
  top: 188px;
  left: 108px;
  width: 23px;
  height: 75px;
  content: '';
  transform: rotate(-10deg);
}

.astronaut__foot-left {
  background-color: white;
  position: absolute;
  top: 240px;
  left: 43px;
  width: 28px;
  height: 20px;
  content: '';
  transform: rotate(10deg);
  border-radius: 3px;
  border-top-left-radius: 8em;
  border-top-right-radius: 8em;
  border-bottom: 4px solid #f49821;
}

.astronaut__foot-right {
  background-color: white;
  position: absolute;
  top: 240px;
  left: 111px;
  width: 28px;
  height: 20px;
  content: '';
  transform: rotate(-10deg);
  border-radius: 3px;
  border-top-left-radius: 8em;
  border-top-right-radius: 8em;
  border-bottom: 4px solid #f49821;
}


.balao {
  position: relative;
  background-color: #fff;
  border: 2px solid #f49821;
  border-radius: 23px;
  padding: 10px;
  max-width: 300px;
  margin: 10px;
  margin-top: -54px;
  font-size:12px;
  text-align: center;
  line-height: 1.5!important;

  
}

.balao::after {
  content: "";
  position: absolute;
  bottom: -40px;
  left: 50%;
  border-width: 20px;
  border-style: solid;
  border-color: #f49821 transparent transparent transparent;
  transform: translateX(-50%);
}

.balao p {
  margin: 0;
  padding: 0;
}


@keyframes visor-reflexo {
  0% {
    opacity: 0.2;
  }
  50% {
    opacity: 0.5;
  }
  100% {
    opacity: 0.2;
  }
}

.astronaut__head-visor {
  position: absolute;
  top: 60px;
  left: 60px;
  width: 60px;
  height: 60px;
  content: '';
  border-radius: 2em;
  overflow: hidden;
}

.astronaut__head-visor:after {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: radial-gradient(circle, rgba(255, 255, 255, 0.6), transparent);
  opacity: 0.2;
  animation: visor-reflexo 2s ease-in-out infinite;
}

</style>

<div class="astronaut box goaway">
    <div class="balao">

        <p class="titulo-linha-1"><span class="fundo-roxo"></span></p>
    </div>
  <div class="astronaut__backpack"></div>
  <div class="astronaut__body"></div>
  <div class="astronaut__body__chest" align="center">
    <img src="images/logo/logo-full.png" width="80%">
  </div>
  <div class="astronaut__arm-left1"></div>
  <div class="astronaut__arm-left2"></div>
  <div class="astronaut__arm-right1"></div>
  <div class="astronaut__arm-right2"></div>
  <div class="astronaut__arm-thumb-left"></div>
  <div class="astronaut__arm-thumb-right"></div>
  <div class="astronaut__leg-left"></div>
  <div class="astronaut__leg-right"></div>
  <div class="astronaut__foot-left"></div>
  <div class="astronaut__foot-right"></div>
  <div class="astronaut__wrist-left"></div>
  <div class="astronaut__wrist-right"></div>
  
  <div class="astronaut__cord" style="margin-left:-30px">
    <canvas id="cord" height="500px" width="500px"></canvas>
  </div>
 
  <div class="astronaut__head astronaut__head-visor">
    
    <canvas id="visor" width="60px" height="60px"></canvas>
    <div class="astronaut__head-visor-flare1"></div>
    <div class="astronaut__head-visor-flare2"></div>
  </div>
</div>

<script> 

var nome = "<?php echo $usuario_visu[0]['nome'] ?>";
var agencia = "<?php foreach ($data as $item) { echo $item['nome']; } ?>";

//BALÃO
function typeWriter(elemento) {
  const textos = ['Seja bem vindo(a) novamente ' + nome + '!', 'Nós da ' + agencia + ' estamos sempre prontos para lhe ajudar!', 'Até já! bye bye!!!'];
  let contador = 0;
  
  setInterval(() => {
    const textoArray = textos[contador].split('');
    elemento.innerHTML = '';
    
    textoArray.forEach((letra, i) => {
      setTimeout(() => elemento.innerHTML += letra, 75 * i);
    });
    
    contador++;
    if (contador >= textos.length) {
      contador = 0;
    }
  }, 7000);
}

const titulo = document.querySelector('.fundo-roxo');
typeWriter(titulo);



    function drawVisor() {
  const canvas = document.getElementById('visor');
  const ctx = canvas.getContext('2d');
  
  ctx.beginPath();
  ctx.moveTo(5, 45);
  ctx.bezierCurveTo(15, 64, 45, 64, 55, 45);
  
  ctx.lineTo(55, 20);
  ctx.bezierCurveTo(55, 15, 50, 10, 45, 10);
  
  ctx.lineTo(15, 10);
  
  ctx.bezierCurveTo(15, 10, 5, 10, 5, 20);
  ctx.lineTo(5, 45);
  
  ctx.fillStyle = '#2f3640';
  ctx.strokeStyle = '#f5f6fa';
  ctx.fill();
  ctx.stroke();
}

const cordCanvas = document.getElementById('cord');
const ctx = cordCanvas.getContext('2d');

let y1 = 160;
let y2 = 100;
let y3 = 100;

let y1Forward = true;
let y2Forward = false;
let y3Forward = true;

function animate() {
  requestAnimationFrame(animate);
  ctx.clearRect(0, 0, innerWidth, innerHeight);
  
  ctx.beginPath();
  ctx.moveTo(130, 170);
  ctx.bezierCurveTo(250, y1, 345, y2, 400, y3);
  
  ctx.strokeStyle = '#f49821';
  ctx.lineWidth = 8;
  ctx.stroke();
 
  
  if (y1 === 100) {
    y1Forward = true;
  }
  
  if (y1 === 300) {
    y1Forward = false;
  }
  
  if (y2 === 100) {
    y2Forward = true;
  }
  
  if (y2 === 310) {
    y2Forward = false;
  }
  
  if (y3 === 100) {
    y3Forward = true;
  }
  
  if (y3 === 317) {
    y3Forward = false;
  }
  
  y1Forward ? y1 += 1 : y1 -= 1;
  y2Forward ? y2 += 1 : y2 -= 1;
  y3Forward ? y3 += 1 : y3 -= 1;
}

drawVisor();
animate();


document.addEventListener('DOMContentLoaded', function(){ 
    // Verifique se a sessão está iniciada e se o astronauta ainda não foi exibido nesta sessão
    <?php if (isset($_SESSION["loggedin"]) && !isset($_SESSION["astronaut_displayed"])) { ?>
        // Sessão iniciada e o astronauta ainda não foi exibido, mostrar o astronauta
        $(".goaway").show();
        
        // Definir a variável de sessão indicando que o astronauta já foi exibido nesta sessão
        <?php $_SESSION["astronaut_displayed"] = true; ?>
        
        // Ocultar o astronauta depois de 30 segundos
        setTimeout(function() {
            $(".goaway").fadeOut().empty();
        }, 26000);
    <?php } else { ?>
        // Sessão não iniciada ou o astronauta já foi exibido nesta sessão, ocultar o astronauta
        $(".goaway").fadeOut().empty();
    <?php } ?>
}, false);

</script>