<?php
// Inicialize a sessão
session_start();

// Verifique se o usuário já está logado, em caso afirmativo, redirecione-o para a página de boas-vindas
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
	header("location: index.php");
	exit;
}

// Incluir arquivo de configuração
require_once "includes/conecta.php";

// Defina variáveis e inicialize com valores vazios
$username = $password = "";
$username_err = $password_err = $login_err = "";

// Processando dados do formulário quando o formulário é enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {

	// Verifique se o nome de usuário está vazio
	if (empty(trim($_POST["username"]))) {
		$username_err = "Por favor, insira o nome de usuário.";
	} else {
		$username = trim($_POST["username"]);
	}

	// Verifique se a senha está vazia
	if (empty(trim($_POST["password"]))) {
		$password_err = "Por favor, insira sua senha.";
	} else {
		$password = trim($_POST["password"]);
	}

	// Validar credenciais
	if (empty($username_err) && empty($password_err)) {
		// Prepare uma declaração selecionada
		$sql = "SELECT id, username, password FROM users WHERE username = :username";

		if ($stmt = $pdo->prepare($sql)) {
			// Vincule as variáveis à instrução preparada como parâmetros
			$stmt->bindParam(":username", $param_username, PDO::PARAM_STR);

			// Definir parâmetros
			$param_username = trim($_POST["username"]);

			// Tente executar a declaração preparada
			if ($stmt->execute()) {
				// Verifique se o nome de usuário existe, se sim, verifique a senha
				if ($stmt->rowCount() == 1) {
					if ($row = $stmt->fetch()) {
						$id = $row["id"];
						$username = $row["username"];
						$hashed_password = $row["password"];
						if (password_verify($password, $hashed_password)) {
							// A senha está correta, então inicie uma nova sessão
							session_start();

							// Armazene dados em variáveis de sessão
							$_SESSION["loggedin"] = true;
							$_SESSION["id"] = $id;
							$_SESSION["username"] = $username;

							// Redirecionar o usuário para a página de boas-vindas
							header("location: index.php");
						} else {
							// A senha não é válida, exibe uma mensagem de erro genérica
							$login_err = "Nome de usuário ou senha inválidos.";
						}
					}
				} else {
					// O nome de usuário não existe, exibe uma mensagem de erro genérica
					$login_err = "Nome de usuário ou senha inválidos.";
				}
			} else {
				echo "Ops! Algo deu errado. Por favor, tente novamente mais tarde.";
			}

			// Fechar declaração
			unset($stmt);
		}
	}

	// Fechar conexão
	unset($pdo);
}
?>
<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="keywords" content="">
	<meta name="author" content="">
	<meta name="robots" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="CryptoZone : Crypto Trading Admin Bootstrap 5 Template">
	<meta property="og:title" content="CryptoZone  :Crypto Trading Admin Bootstrap 5 Template">
	<meta property="og:description" content="CryptoZone  :Crypto Trading Admin  Admin Bootstrap 5 Template">
	<meta property="og:image" content="social-image.png">
	<meta name="format-detection" content="telephone=no">

	<!-- PAGE TITLE HERE -->
	<title>GDC CMS</title>

	<!-- FAVICONS ICON -->
	<link rel="shortcut icon" type="image/png" href="images/favicon.png">
	<link href="vendor/jquery-nice-select/css/nice-select.css" rel="stylesheet">
	<link href="css/style.css" rel="stylesheet">





</head>

<body class="vh-100">
	<div class="page-wraper">

		<!-- Content -->
		<div class="browse-job login-style3">
			<!-- Coming Soon -->
			<div class="bg-img-fix overflow-hidden" style="background:#fff url(images/background/bg6.jpg); height: 100vh;">


				<div class="row gx-0">
					<div class="col-xl-4 col-lg-5 col-md-6 col-sm-12 vh-100 bg-white ">
						<div id="mCSB_1" class="mCustomScrollBox mCS-light mCSB_vertical mCSB_inside" style="max-height: 653px;" tabindex="0">
							<div id="mCSB_1_container" class="mCSB_container" style="position:relative; top:0; left:0;" dir="ltr">
								<div class="login-form style-2">


									<div class="card-body">
										<div class="logo-header">
											<a href="login.php" class="logo"><img src="images/logo/logo-color.svg" alt="" class="width-230 mCS_img_loaded"></a>
										</div>

										<nav>
											<div class="nav nav-tabs border-bottom-0" id="nav-tab" role="tablist">

												<div class="tab-content w-100" id="nav-tabContent">
													<div class="tab-pane fade show active" id="nav-personal" role="tabpanel" aria-labelledby="nav-personal-tab">
														<?php
														if (!empty($login_err)) {
															echo '<div class="alert alert-danger">' . $login_err . '</div>';
														}
														?>

														<form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class=" dz-form pb-3">
															<h3 class="form-title m-t0">Painel admin</h3>
															<div class="dz-separator-outer m-b5">
																<div class="dz-separator bg-primary style-liner"></div>
															</div>
															<p>Insira seu login e senha para entrar: </p>
															<div class="form-group mb-3">
																<input name="username" required="" value="<?php echo $username; ?>" class="form-control <?php echo (!empty($username_err)) ? 'is-invalid' : ''; ?>" placeholder="Usuário" type="text">
																<span class="invalid-feedback"><?php echo $username_err; ?></span>
															</div>
															<div class="form-group mb-3">
																<input name="password" required="" class="form-control <?php echo (!empty($password_err)) ? 'is-invalid' : ''; ?>" placeholder="Senha" type="password">
																<span class="invalid-feedback"><?php echo $password_err; ?></span>
															</div>
															<div class="form-group text-left mb-5">
																<button class="btn btn-primary dz-xs-flex m-r5">Entrar</button>


															</div>

														</form>

													</div>



												</div>
										</nav>
									</div>
									<div class="card-footer">
										<div class=" bottom-footer clearfix m-t10 m-b20 row text-center">
											<div class="col-lg-12 text-center">
												<span> © Copyright by <span class="heart"></span>
													<a href="javascript:void(0);">GDC Software </a> Todos os direitos reservados.</span>
											</div>
										</div>
									</div>

								</div>
							</div>
							<div id="mCSB_1_scrollbar_vertical" class="mCSB_scrollTools mCSB_1_scrollbar mCS-light mCSB_scrollTools_vertical" style="display: block;">
								<div class="mCSB_draggerContainer">
									<div id="mCSB_1_dragger_vertical" class="mCSB_dragger" style="position: absolute; min-height: 0px; display: block; height: 652px; max-height: 643px; top: 0px;">
										<div class="mCSB_dragger_bar" style="line-height: 0px;"></div>
										<div class="mCSB_draggerRail"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Full Blog Page Contant -->
		</div>
		<!-- Content END-->
	</div>

	<!--**********************************
	Scripts
***********************************-->
	<!-- Required vendors -->
	<script src="vendor/global/global.min.js"></script>
	<script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>
	<script src="js/deznav-init.js"></script>
	<script src="js/custom.js"></script>
	<script src="js/demo.js"></script>

</body>

</html>