<?php
$usuario_up_id = $_GET["id"];
$gerapixel = "_pixel_imagem_";

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  
  // Verifica se foi enviada uma imagem
  if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === UPLOAD_ERR_OK) {
    
    // Obtém informações sobre a imagem enviada
    $nome = $_FILES['imagem']['name'];
    $tipo = $_FILES['imagem']['type'];
    $tamanho = $_FILES['imagem']['size'];
    $temp = $_FILES['imagem']['tmp_name'];
    
    // Define o diretório de destino para a imagem
    $destino = 'images/logos/' . $usuario_up_id . $gerapixel . $nome;
    
    // Redimensiona a imagem para um tamanho máximo de 800x800 pixels
    $img = imagecreatefromstring(file_get_contents($temp));
    $largura = imagesx($img);
    $altura = imagesy($img);
    $max_largura = 800;
    $max_altura = 800;
    if ($largura > $max_largura || $altura > $max_altura) {
      $proporcao = min($max_largura/$largura, $max_altura/$altura);
      $nova_largura = round($proporcao * $largura);
      $nova_altura = round($proporcao * $altura);
      $nova_img = imagecreatetruecolor($nova_largura, $nova_altura);
      imagecopyresampled($nova_img, $img, 0, 0, 0, 0, $nova_largura, $nova_altura, $largura, $altura);
      imagedestroy($img);
      $img = $nova_img;
    }
    
    // Salva a imagem no diretório de destino
    imagejpeg($img, $destino);
    imagedestroy($img);
    
    // Conecta ao banco de dados
    $pdo = new PDO('mysql:host=localhost;dbname=cms_pixel', 'root', 'firewall123');
    
    // Verifica se o usuário já possui uma foto no banco de dados
    $stmt = $pdo->prepare('SELECT * FROM config WHERE id = :id');
    $stmt->execute(array(':id' => $usuario_up_id));
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Se o usuário já possui uma foto, atualiza seus dados no banco de dados
    if ($user['logo'] !== null) {
      $stmt = $pdo->prepare('UPDATE config SET logo = :logo WHERE id = :id');
      $stmt->execute(array(
        ':id' => $user['id'],
        ':logo' => $destino
      ));
    }
    
    // Se o usuário não possui uma foto, insere seus dados no banco de dados
    else {
      $stmt = $pdo->prepare('INSERT INTO config (logo) VALUES (:logo) WHERE id = :id');
      $stmt->execute(array(
        ':id' => $user['id'],
        ':logo' => $destino
      ));
      
    }
    // Redireciona o usuário para a página de destino
    header('Location: configuracoes.php?status=ok&id=' . $usuario_up_id. '');
    exit;
    
  }
  
}
?>