<div class="col-xl-4 col-lg-12 col-sm-12">
	<div class="card">
		<div class="card-header">
			<h4 class="card-title">Gráfico de visitas <a href="#" class="badge badge-sm light badge-danger ms-1" data-bs-container="body" data-bs-toggle="popover" data-bs-placement="top" data-bs-content="Para métricas mais precisas é aconselhado utilizar outros gerenciadores exemplo: Google Analytics." aria-describedby="popover500285">info</a></h4>
		</div>
		<div class="card-body">
			<canvas id="barChart_1"></canvas>
		</div>
	</div>
</div>
<?php
require_once('includes/conecta.php');

// Consulta para obter as visitas agrupadas por dia
$sql = "SELECT DATE(data) AS dia, COUNT(*) AS total FROM visitas GROUP BY dia ORDER BY dia";

$resultado = mysqli_query($conn, $sql);

// Crie arrays para armazenar os dados do gráfico
$labels = array();
$dados = array();

// Processar os resultados da consulta
while ($linha = mysqli_fetch_assoc($resultado)) {
    $labels[] = date('d/m/Y', strtotime($linha['dia']));
    $dados[] = $linha['total'];
}


// Feche a conexão com o banco de dados
mysqli_close($conn);
?>


<script src="vendor/chart.js/Chart.bundle.min.js"></script>
	
    
<script>
var barChart1 = function(){
    if(jQuery('#barChart_1').length > 0 ){
        const barChart_1 = document.getElementById("barChart_1").getContext('2d');

        barChart_1.height = 100;

        new Chart(barChart_1, {
            type: 'bar',
            data: {
                defaultFontFamily: 'Poppins',
                labels: <?php echo json_encode($labels);  ?>,
                datasets: [
                    {
                        label: "Total de Visitas",
                        data: <?php echo json_encode($dados);  ?>,
                        borderColor: '#fff',
                        borderWidth: "0",
                        colors: '#fff',
                        backgroundColor: 'rgba(149, 104, 255, 1)'
                    }
                ]
            },
            options: {
                legend: false, 
                
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            fontColor:'#fff',
                        },
                        gridLines:{
                            color:"rgba(255, 255, 255, 0.1)"
                        }
                        
                        
                    }],
                    
                    xAxes: [{
                        barPercentage: 0.5,
                        ticks:{
                            fontColor:'#ffffff',
                        },
                        gridLines:{
                            color:"rgba(255, 255, 255, 0.1)"
                        }
                    }]
                },
                
            }
        });
    }
}
barChart1();
</script>