<div class="col-xl-6 col-lg-12 col-sm-12">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Basic Line Chart</h4>
        </div>
        <div class="card-body">
            <canvas id="lineChart_1"></canvas>
        </div>
    </div>
</div>
<?php
require_once('includes/conecta.php');

// Consulta para obter as visitas agrupadas por mês
$sql = "SELECT DATE_FORMAT(data, '%b') AS mes, COUNT(*) AS total FROM visitas GROUP BY mes ORDER BY data";

$resultado = mysqli_query($conn, $sql);

// Crie arrays para armazenar os dados do gráfico
$labels = array();
$dados = array();

// Processar os resultados da consulta
while ($linha = mysqli_fetch_assoc($resultado)) {
    $labels[] = $linha['mes'];
    $dados[] = $linha['total'];
}

echo json_encode($dados);
echo json_encode($labels);

mysqli_close($conn);
?>

<script src="vendor/global/global.min.js"></script>
<script src="vendor/jquery-nice-select/js/jquery.nice-select.min.js"></script>
<script src="vendor/chart.js/Chart.bundle.min.js"></script>
<script src="js/plugins-init/chartjs-init.js"></script>
	
    
<script>
var lineChart1 = function(){
		
		
		if(jQuery('#lineChart_1').length > 0 ){


		//basic line chart
			const lineChart_1 = document.getElementById("lineChart_1").getContext('2d');

			Chart.controllers.line = Chart.controllers.line.extend({
				draw: function () {
					draw.apply(this, arguments);
					let nk = this.chart.chart.ctx;
					let _stroke = nk.stroke;
					nk.stroke = function () {
						nk.save();
						nk.shadowColor = 'rgba(255, 0, 0, .2)';
						nk.shadowBlur = 10;
						nk.shadowOffsetX = 0;
						nk.shadowOffsetY = 10;
						_stroke.apply(this, arguments)
						nk.restore();
					}
				}
			});
			
			lineChart_1.height = 100;

			new Chart(lineChart_1, {
				type: 'line',
				data: {
					defaultFontFamily: 'Poppins',
					labels: <?php echo json_encode($labels); ?>,
					datasets: [
						{
							label: "Total de Visitas",
							data: <?php echo json_encode($dados); ?>,
							borderColor: 'rgba(149, 104, 255, 1)',
							borderWidth: "2",
							backgroundColor: 'transparent',  
							pointBackgroundColor: 'rgba(149, 104, 255, 1)'
						}
					]
				},
				options: {
					legend: false, 
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero: true, 
								max: 100, 
								min: 0, 
								stepSize: 20, 
								padding: 10,
								fontColor:	'#ffffff',
							},
							gridLines:{
								color:"rgba(255, 255, 255, 0.1)"
							}
						}],
						xAxes: [{
							ticks: {
								padding: 5,
								fontColor:	'#ffffff',
							},
							gridLines:{
								color:"rgba(255, 255, 255, 0.1)"
							}
						}]
					}
				}
			});
			
		}
	}


</script>

